require("stategraphs/commonstates")

local function SetWeaponBullet(inst)
    local ewep = inst.components.inventory:GetEquippedItem(EQUIPSLOTS.HANDS)
    if ewep == nil then
	inst:PushEvent("checkwep")
    end
    inst.components.inventory:GetEquippedItem(EQUIPSLOTS.HANDS).components.weapon:SetProjectile("esentry_bullet")
    if inst.components.fueled.currentfuel ~= 0 and inst.components.combat.target then
        inst.components.combat:DoAttack()
	inst.components.fueled.currentfuel = inst.components.fueled.currentfuel - 1
	inst.SoundEmitter:PlaySound("dontstarve/creatures/rocklobster/explode")
    end
    inst:PushEvent("namedinfo")
end

local function SetWeaponRocket(inst)
    local ewep = inst.components.inventory:GetEquippedItem(EQUIPSLOTS.HANDS)
    if ewep == nil then
	inst:PushEvent("checkwep")
    end
    inst.components.inventory:GetEquippedItem(EQUIPSLOTS.HANDS).components.weapon:SetProjectile("esentry_rocket")
    inst.components.combat:DoAttack()
    inst.SoundEmitter:PlaySound("dontstarve/creatures/rocklobster/explode")
end

local function SetIdleAnim(inst)
    if inst:HasTag("lvl1") then
	inst.AnimState:PlayAnimation("idle_loop", true)
    elseif inst:HasTag("lvl2") then
	inst.AnimState:PlayAnimation("idle_loop_2", true)
    elseif inst:HasTag("lvl3") then
	inst.AnimState:PlayAnimation("idle_loop_3", true)
    end
    inst:PushEvent("namedinfo")
end

local events=
{    
    EventHandler("death", function(inst) inst.sg:GoToState("death") end),
    EventHandler("doattack", function(inst, target)
	if inst.components.fueled.currentfuel ~= 0 then
            if not inst.components.health:IsDead() and (inst.sg:HasStateTag("hit") or not inst.sg:HasStateTag("busy")) then 
            	inst.sg:GoToState("attack") 
	    end
	end
    end),
    CommonHandlers.OnDeath(),
    EventHandler("attacked", function(inst) 
        if not inst.components.health:IsDead() and not 
            inst.sg:HasStateTag("attack") then
            inst.sg:GoToState("hit") 
        end 
    end)
}

local states=
{   
    State{
        name = "idle",
        tags = {"idle", "canrotate"},
        onenter = function(inst)
	    SetIdleAnim(inst)
        end, 
        events=
        {
            EventHandler("animover", function(inst) inst.sg:GoToState("idle") end),
        },
    },
    
    State{
        name = "death",
        tags = {"busy"},
        
        onenter = function(inst)  
            inst.components.lootdropper:DropLoot()
	    local fx = SpawnPrefab("collapse_small")
	    fx.Transform:SetPosition(inst.Transform:GetWorldPosition())
	    inst:Remove()
        end,

        timeline = 
        {
            TimeEvent(17*FRAMES, function(inst) inst.SoundEmitter:PlaySound("dontstarve/characters/wx78/spark") end)
        },
    },    
        
    State{
        name = "hit",
        tags = {"hit"},
        
        onenter = function(inst)
	    inst:PushEvent("hitanim")
	end,
        
        events=
        {
            EventHandler("animover", function(inst) inst.sg:GoToState("idle") end),
        },        
    },

    State
    { 
        name = "attack",
        tags = {"attack", "canrotate"},
        onenter = function(inst, target)
            inst.components.lighttweener:StartTween(nil, 0, .65, .7, nil, 0, function(inst, light) if light then light:Enable(true) end end)
            inst.components.lighttweener:StartTween(nil, 3.5, .9, .9, nil, .66, inst.dotweenin)
	    if inst:HasTag("lvl1") then
		inst.AnimState:PlayAnimation("atk", true)
	    elseif inst:HasTag("lvl2") then
		inst.AnimState:PlayAnimation("atk2", true)
	    elseif inst:HasTag("lvl3") then
		inst.AnimState:PlayAnimation("atk3", true)
	    end
        end,
       
        timeline=
        {
            TimeEvent(2*FRAMES, function(inst)
		if inst:HasTag("lvl1") or inst:HasTag("lvl2") or inst:HasTag("lvl3") then
		    SetWeaponBullet(inst)
		end
            end),
            TimeEvent(4*FRAMES, function(inst)
		if inst:HasTag("lvl2") or inst:HasTag("lvl3") then
		    SetWeaponBullet(inst)
		end
            end),
            TimeEvent(6*FRAMES, function(inst)
		if inst:HasTag("lvl1") or inst:HasTag("lvl2") or inst:HasTag("lvl3") then
		    SetWeaponBullet(inst)
		end
            end),
            TimeEvent(8*FRAMES, function(inst)
		if inst:HasTag("lvl2") or inst:HasTag("lvl3") then
		    SetWeaponBullet(inst)
		end
	    end),
            TimeEvent(10*FRAMES, function(inst)
		if inst:HasTag("lvl1") or inst:HasTag("lvl2") or inst:HasTag("lvl3") then
		    SetWeaponBullet(inst)
		end
	    end),
            TimeEvent(12*FRAMES, function(inst)
		if inst:HasTag("lvl2") or inst:HasTag("lvl3") then
		    SetWeaponBullet(inst)
		end
	    end),

            TimeEvent(13*FRAMES, function(inst)
		SetIdleAnim(inst)
	    end),

            TimeEvent(14*FRAMES, function(inst)
	    	if inst.components.fueled.currentfuel >= 2 and inst.components.combat.target and inst:HasTag("rocketsready") then
		    inst.AnimState:PlayAnimation("atk3_rockets", true)
		    inst.components.fueled.currentfuel = inst.components.fueled.currentfuel - 2
		    inst:RemoveTag("rocketsready")
		    inst:PushEvent("rocketsshot")
		    SetWeaponRocket(inst)
		    inst:DoTaskInTime(2*FRAMES, function(inst)
		        SetWeaponRocket(inst)
		    end)
		    inst:DoTaskInTime(4*FRAMES, function(inst)
		        SetWeaponRocket(inst)
		    end)
		    inst:DoTaskInTime(6*FRAMES, function(inst)
		        SetWeaponRocket(inst)
		    end)
	        end
	    end),

            TimeEvent(20*FRAMES, function(inst)
		SetIdleAnim(inst)
		inst:DoTaskInTime(SENTRY_ROF, function(inst)
		    inst.sg:GoToState("idle")
		end)
	    end),
        },

    },   
}
    
return StateGraph("esentry", states, events, "idle")
